﻿responseValidation = {
    errorCodes: { "invalidChoice": 0 },
    questionCodes: [],
    selectedVariables: [],
    selectedQuestionsWithCodeWidth: [],
    selectedQuestionsWithMask: [],
    questionCodeWidth: 0,
    allowSaveDisabling: true,
    initialize: function (result, allowSaveDisabling) {
        responseValidation.selectedVariables = (result.selectedQuestions) ? result.selectedQuestions.split(',') : [];
        responseValidation.selectedQuestionsWithCodeWidth = result.selectedQuestionsWithCodeWidth || [];
        responseValidation.selectedQuestionsWithMask = result.selectedQuestionsWithMask || [];


        if (allowSaveDisabling !== undefined)
            responseValidation.allowSaveDisabling = allowSaveDisabling;
    },
    verifyRowData: function (flagError, data, index, fieldName, update, single, showError, ignoreCodeValidation, openEndCodingOptions = undefined) {
        var content;
        var variable;
        if (single == null)
            single = true

        switch (fieldName) {
            case "OpenEnd": content = data.Content; variable = data.Question; break;
            case "Content": content = data.Content; variable = data.Question; break;
            case "PreCode": content = data.PreCode; variable = data.Question; break;
            case "Variable0": content = data.Variable0; variable = data.Variable0Name; break;
            case "Variable1": content = data.Variable1; variable = data.Variable1Name; break;
            case "Variable2": content = data.Variable2; variable = data.Variable2Name; break;
            case "Variable3": content = data.Variable3; variable = data.Variable3Name; break;
            case "Variable4": content = data.Variable4; variable = data.Variable4Name; break;
            case "Variable5": content = data.Variable5; variable = data.Variable5Name; break;
            case "Variable6": content = data.Variable6; variable = data.Variable6Name; break;
            case "Variable7": content = data.Variable7; variable = data.Variable7Name; break;
            case "Variable8": content = data.Variable8; variable = data.Variable8Name; break;
            case "Variable9": content = data.Variable9; variable = data.Variable9Name; break;
        }

        responseValidation.questionCodeWidth = data.CodeWidth ? data.CodeWidth : responseValidation.selectedQuestionsWithCodeWidth[variable];

        if (content) {
            content = content.trim();

            if (content.length > responseValidation.questionCodeWidth && single) {
                flagError(responseValidation.allowSaveDisabling);
                if (showError)
                    responseValidation.showLengthErrorMessage(resources.MaxCodeLengthExceeded, variable);
            }
            else if (responseValidation.questionCodes[variable] != null && responseValidation.questionCodes[variable].length > 0) {
                if (!_.any(responseValidation.questionCodes[variable]) || !responseValidation.verifyDataContent(content, single)) {
                    flagError(responseValidation.allowSaveDisabling);
                }
                else if ((!ignoreCodeValidation && !responseValidation.verifyDataContentCodes(_.pluck(responseValidation.questionCodes[variable], "Code"), content)) || !responseValidation.verifyDataContentMask(responseValidation.selectedQuestionsWithMask[variable], content)) {
                    flagError(false);
                }
            }
            else if (!responseValidation.verifyDataContentMask(responseValidation.selectedQuestionsWithMask[variable], content)) {
                flagError(false);
            }

            if (variable !== undefined && openEndCodingOptions !== undefined) {
                var matchedCode = (openEndCodingOptions[variable] !== undefined) ? openEndCodingOptions[variable].find(e => e.Code === content) : undefined;

                if (matchedCode === undefined || !(matchedCode.hasOwnProperty('CanDelete'))) {
                    responseValidation.allowSaveDisabling = false;
                    flagError(responseValidation.allowSaveDisabling);
                }
            }
        }
        else if (update && (fieldName == 'Content' || fieldName == 'PreCode' || fieldName == 'OpenEnd')) {
            flagError(responseValidation.allowSaveDisabling, true);
            if (showError)
                responseValidation.showEmptyErrorMessage();
        }

        if (update && content && !single) {
            var mentions = _.without(content.split(' '), "");

            if (mentions.length > 0) {
                var idx = 0;
                var updateCount = 0;        // Possible that we have multiple mentions, but that the open end displayed is only the 3rd or something other than the first mention. They are not necessarily consecutive
                var nextRowData = null;
                var updatedPrevious = false;

                do {
                    if (!nextRowData || updatedPrevious)
                        nextRowData = openEndCoding.datatable.a4datatable("getRowData", (index + idx));

                    updatedPrevious = false;

                    if (nextRowData.CaseId == data.CaseId && nextRowData.Mention == (idx + 1)) {
                        openEndCoding.datatable.a4datatable("updateItem", index + (updateCount++), { fieldName: mentions[idx] });
                        updatedPrevious = true;
                    }
                }
                while (++idx < mentions.length && idx < openEndCoding.questionMaxAnswers);
            }
        }

    },
    setQuestionCodes: function (codes) {
        responseValidation.questionCodes = codes;
    },
    setQuestionMask: function (masks) {
        responseValidation.selectedQuestionsWithMask = masks;
    },
    loadSelectedQuestionCodes: function (questionName) {
        var loadedQuestions = _.keys(responseValidation.questionCodes);
        var questionsToLoad = _.union(responseValidation.selectedVariables, [questionName]);

        if (loadedQuestions) {
            questionsToLoad = _.difference(questionsToLoad, loadedQuestions);
        }

        if (questionsToLoad && questionsToLoad.length > 0) {
            return a4.callServerMethod(a4.getProjectAction("GetQuestionsCodes", "Shared"), { questionsName: _.compact(questionsToLoad).join(",") }, function (result) {
                if (responseValidation.questionCodes == null)
                    responseValidation.questionCodes = {};

                _.each(result, function (value, key) {
                    responseValidation.questionCodes[key] = value;
                });
            });
        }
    },
    verifyDataContent: function (data, singleMention) {
        var valid = true;
        var mentions = _.without(data.split(' '), "");

        if (singleMention && (mentions.length > 1 || data.length > responseValidation.questionCodeWidth)) {
            valid = false;
        }
        else if (!singleMention && (mentions.length > openEndCoding.questionMaxAnswers || _.any(mentions, function (m) { return m.length > responseValidation.questionCodeWidth; }))) {
            valid = false;
        }

        return valid;
    },
    verifyDataContentMask: function (mask, data) {
        var valid = true;
        var mentions = _.without(data.split(' '), "");

        _.each(mentions, function (m) {
            if (valid) {
                if (typeof mask !== "undefined" && mask.Mask.length > 0 && (mask.Mask.startsWith("$E") || mask.Mask.startsWith("$R")))
                {
                    if (!isNaN(m) && (mask.LowerBound.length == 0 || parseFloat(m) >= parseFloat(mask.LowerBound)) && (mask.UpperBound.length == 0 || parseFloat(m) <= parseFloat(mask.UpperBound)))
                        valid = true;
                    else
                        valid = false;
                }
                else
                    valid = true;
            }
        });

        return valid;
    },
    verifyDataContentCodes: function (codes, data) {
        var valid = true;
        var mentions = _.without(data.split(' '), "");

        _.each(mentions, function (m) {
            if (valid) {
                valid = _.contains(codes, m.trim());
            }
        });

        return valid;
    },
    showLengthErrorMessage: function (message, variable) {
        var errorResources = {
            "Name": variable,
            "Length": responseValidation.questionCodeWidth
        };

        message = message.replace(/{(.*?)}/g, function (group, value) {
            return errorResources[value];
        });
        a4.showErrorMessage(message);
    },
    showEmptyErrorMessage: function () {
        a4.showErrorMessage(resources.EmptyCode);
    },
    showInvalidChoiceMessage: function (choice) {
        a4.showErrorMessage(resources.InvalidQuestionChoice);
    }
}

